<script>
    const toast = (type = 'info', title = '', message = '') => {
        cuteToast({
            type: type,
            title: title,
            message: message,
            timer: 5000
        })
    }

    $(function() {
        @if ($errors->any())
            @foreach ($errors->all() as $i => $error)
                cuteToast({
                    type: "error",
                    title: "Error",
                    message: "{{ $error }}",
                    timer: 1000 * ({{ $i }} + 1)
                })
            @endforeach
        @endif

        @if (session('error'))
            cuteToast({
                type: "error",
                title: "Error",
                message: "{{ session('error') }}",
                timer: 5000
            })
        @endif
        @if (session('success'))
            cuteToast({
                type: "success",
                title: "Success",
                message: "{{ session('success') }}",
                timer: 5000
            })
        @endif
        @if (session('warning'))
            cuteToast({
                type: "warning",
                title: "Warning",
                message: "{{ session('warning') }}",
                timer: 5000
            })
        @endif
        @if (session('info'))
            cuteToast({
                type: "info",
                title: "Info",
                message: "{{ session('info') }}",
                timer: 5000
            })
        @endif

        @if (session('status'))
            cuteToast({
                type: "success",
                title: "Success",
                message: "{{ session('status') }}",
                timer: 5000
            })
        @endif
    });
</script>
